import type { Metadata } from "next";
import { Inter } from "next/font/google";
import "./globals.css";
import Navbar from "./components/Navbar";
import PayPalProvider from "./components/PayPalProvider";
import { ToastProvider } from "./context/ToastContext";

const inter = Inter({ subsets: ["latin"] });

export const metadata: Metadata = {
  title: "JomHUB | Premium Roblox Scripts",
  description: "The best place for Roblox scripts and services.",
  icons: {
    icon: '/logo.gif', // Updated to support GIF
  }
};

export default function RootLayout({
  children,
}: Readonly<{
  children: React.ReactNode;
}>) {
  return (
    <html lang="en">
      <body className={`${inter.className} bg-black text-white overflow-x-hidden`}>
        {/* Animated Background */}
        <div className="fixed inset-0 z-[-1]">
             <div className="absolute inset-0 bg-[radial-gradient(ellipse_at_top,_var(--tw-gradient-stops))] from-purple-900/20 via-black to-black"></div>
             <div className="absolute top-0 left-0 right-0 h-[500px] bg-gradient-to-b from-purple-500/5 to-transparent opacity-50 blur-3xl"></div>
        </div>
        
        <PayPalProvider>
          <ToastProvider>
            <Navbar />
            <main className="pt-20 min-h-screen">{children}</main>
          </ToastProvider>
        </PayPalProvider>
      </body>
    </html>
  );
}
