import { NextResponse } from 'next/server';
import { getSession } from '@/lib/auth';
import { connectToDatabase } from '@/lib/db';
import { Tutorial } from '@/lib/models';

export async function GET() {
  await connectToDatabase();
  const tutorials = await Tutorial.find({}).sort({ createdAt: -1 }).lean();
  
  // Map _id to id
  const mappedTutorials = tutorials.map((t: any) => ({
    ...t,
    id: t._id.toString(),
    _id: undefined
  }));

  return NextResponse.json({ tutorials: mappedTutorials });
}

export async function POST(request: Request) {
  const session = await getSession();
  if (!session || (session.user.role !== 'admin' && session.user.role !== 'staff')) {
    return NextResponse.json({ error: "Unauthorized" }, { status: 403 });
  }

  const { title, description, icon, url, color } = await request.json();
  
  await connectToDatabase();

  const newTutorial = await Tutorial.create({
    title,
    description,
    icon: icon || 'Youtube',
    url,
    color: color || 'text-blue-400'
  });

  return NextResponse.json({ 
    success: true, 
    tutorial: { 
        ...newTutorial.toObject(), 
        id: newTutorial._id.toString(),
        _id: undefined
    } 
  });
}
