import { NextResponse } from 'next/server';
import { connectToDatabase } from '@/lib/db';
import { Service } from '@/lib/models';

export const dynamic = 'force-dynamic'; // Ensure this route is always dynamic

export async function GET() {
  try {
    await connectToDatabase();
    const services = await Service.find({}).sort({ createdAt: -1 }).lean();
    
    return NextResponse.json({ 
      services: services.map((s: any) => ({
          ...s,
          id: s._id.toString(),
          _id: undefined
      }))
    });
  } catch (error) {
    console.error("Failed to fetch services:", error);
    return NextResponse.json({ services: [] }, { status: 500 });
  }
}
