import { NextResponse } from 'next/server';
import { getSession } from '@/lib/auth';
import { connectToDatabase } from '@/lib/db';
import { ServiceRequest } from '@/lib/models';

export async function GET() {
  const session = await getSession();
  if (!session) {
    return NextResponse.json({ error: "Unauthorized" }, { status: 401 });
  }

  await connectToDatabase();

  let requests;
  if (session.user.role === 'admin' || session.user.role === 'staff') {
    // Admin sees ALL requests
    requests = await ServiceRequest.find({}).sort({ updatedAt: -1 }).lean();
  } else {
    // User sees only THEIR requests
    requests = await ServiceRequest.find({ userId: session.user.id }).sort({ updatedAt: -1 }).lean();
  }

  return NextResponse.json({ 
    requests: requests.map((r: any) => ({
        ...r,
        id: r._id.toString(),
        _id: undefined
    })) 
  });
}
