import { readJSON, writeJSON } from '@/lib/store';
import { products } from '@/lib/products';
import { getSession } from '@/lib/auth';
import { NextResponse } from 'next/server';

export async function GET() {
  const session = await getSession();
  if (!session || session.user.role !== 'admin') {
    return NextResponse.json({ error: "Unauthorized" }, { status: 403 });
  }

  // 1. Update Submissions
  const submissions = await readJSON<any[]>('submissions.json');
  let subCount = 0;
  submissions.forEach(s => {
    if (s.productSlug === 'roblox-studio-script') {
        s.productSlug = 'final-stand-remastered';
        s.productName = 'Final Stand: Remastered';
        subCount++;
    }
  });
  if (subCount > 0) await writeJSON('submissions.json', submissions);

  // 2. Update Licenses
  const licenses = await readJSON<any[]>('licenses.json');
  let licCount = 0;
  licenses.forEach(l => {
    if (l.productSlug === 'roblox-studio-script') {
        l.productSlug = 'final-stand-remastered';
        licCount++;
    }
  });
  if (licCount > 0) await writeJSON('licenses.json', licenses);

  // 3. Update Messages
  const messages = await readJSON<any[]>('messages.json');
  let msgCount = 0;
  messages.forEach(m => {
    if (m.productSlug === 'roblox-studio-script') {
        m.productSlug = 'final-stand-remastered';
        m.title = m.title.replace('Roblox Studio Script', 'Final Stand: Remastered');
        m.content = m.content.replace('Roblox Studio Script', 'Final Stand: Remastered');
        msgCount++;
    }
  });
  if (msgCount > 0) await writeJSON('messages.json', messages);

  return Response.json({ success: true, fixed: { submissions: subCount, licenses: licCount, messages: msgCount } });
}
