import { NextResponse } from 'next/server';
import { getSession } from '@/lib/auth';
import { connectToDatabase } from '@/lib/db';
import { Chat } from '@/lib/models';

export async function DELETE(request: Request) {
  const session = await getSession();
  if (!session || (session.user.role !== 'admin' && session.user.role !== 'staff')) {
    return NextResponse.json({ error: "Unauthorized" }, { status: 403 });
  }

  const { id, userId } = await request.json();

  await connectToDatabase();

  let result;
  if (id) {
    // Delete single message
    result = await Chat.findByIdAndDelete(id);
  } else if (userId) {
    // Delete ALL messages from a specific user
    result = await Chat.deleteMany({ userId: userId });
  } else {
    return NextResponse.json({ error: "Must provide message id or userId" }, { status: 400 });
  }

  return NextResponse.json({ success: true, deletedCount: result ? 1 : 0 }); // deleteMany returns {deletedCount: n}, findByIdAndDelete returns doc
}
