import { NextResponse } from 'next/server';
import { getSession } from '@/lib/auth';
import { connectToDatabase } from '@/lib/db';
import { User } from '@/lib/models';

export async function GET() {
  const session = await getSession();
  if (!session) {
    return NextResponse.json({ user: null });
  }

  // Optional: Validate user still exists in DB
  await connectToDatabase();
  const user = await User.findById(session.user.id);
  if (!user) {
      return NextResponse.json({ user: null });
  }

  return NextResponse.json({ user: session.user });
}
