import { NextResponse } from 'next/server';
import { getSession } from '@/lib/auth';
import { connectToDatabase } from '@/lib/db';
import { User } from '@/lib/models';

export async function GET() {
  const session = await getSession();
  if (!session || (session.user.role !== 'admin' && session.user.role !== 'staff')) {
    return NextResponse.json({ error: "Unauthorized" }, { status: 403 });
  }

  await connectToDatabase();
  const users = await User.find({}).select('-password').sort({ createdAt: -1 }).lean();
  
  const mappedUsers = users.map((u: any) => ({
    ...u,
    id: u._id.toString(),
    _id: undefined
  }));

  return NextResponse.json({ users: mappedUsers });
}
