import { NextResponse } from 'next/server';
import { getSession } from '@/lib/auth';
import { connectToDatabase } from '@/lib/db';
import { ServiceRequest, ServiceChat } from '@/lib/models';

export async function POST(request: Request) {
  const session = await getSession();
  if (!session || (session.user.role !== 'admin' && session.user.role !== 'staff')) {
    return NextResponse.json({ error: "Unauthorized" }, { status: 403 });
  }

  const { requestId, transactionId } = await request.json();

  await connectToDatabase();
  const req = await ServiceRequest.findById(requestId);

  if (!req) return NextResponse.json({ error: "Request not found" }, { status: 404 });

  // Force update status
  req.status = 'in_progress';
  req.updatedAt = new Date();
  await req.save();

  // System message
  await ServiceChat.create({
      requestId: requestId,
      senderId: 'system',
      senderRole: 'system',
      message: `Payment MANUALLY verified by Admin (ID: ${transactionId}). Status updated to IN PROGRESS.`
  });

  return NextResponse.json({ success: true });
}
