import { NextResponse } from 'next/server';
import { getSession } from '@/lib/auth';
import { connectToDatabase } from '@/lib/db';
import { License } from '@/lib/models';

export async function GET() {
  const session = await getSession();
  if (!session || (session.user.role !== 'admin' && session.user.role !== 'staff')) {
    return NextResponse.json({ error: "Unauthorized" }, { status: 403 });
  }

  await connectToDatabase();
  const licenses = await License.find({}).sort({ createdAt: -1 }).lean();
  
  // Map _id to id
  const mappedLicenses = licenses.map((l: any) => ({
    ...l,
    id: l._id.toString(),
    _id: undefined
  }));

  return NextResponse.json({ licenses: mappedLicenses });
}
