import { NextResponse } from 'next/server';
import { getSession } from '@/lib/auth';
import { connectToDatabase } from '@/lib/db';
import { License } from '@/lib/models';

export async function POST(request: Request) {
  const session = await getSession();
  if (!session || (session.user.role !== 'admin' && session.user.role !== 'staff')) {
    return NextResponse.json({ error: "Unauthorized" }, { status: 403 });
  }

  const { productSlug, keys } = await request.json();

  if (!productSlug || !keys || !Array.isArray(keys)) {
    return NextResponse.json({ error: "Invalid data" }, { status: 400 });
  }

  await connectToDatabase();

  let addedCount = 0;
  const newLicenses = [];

  for (const key of keys) {
    if (typeof key === 'string' && key.trim() !== '') {
       // Check for duplicate
       const exists = await License.findOne({ key: key.trim() });
       if (!exists) {
         newLicenses.push({
            key: key.trim(),
            productSlug,
            status: 'available',
         });
         addedCount++;
       }
    }
  }

  if (newLicenses.length > 0) {
    await License.insertMany(newLicenses);
  }

  return NextResponse.json({ success: true, count: addedCount });
}
