# Render Migration Guide

This guide helps you migrate your Next.js application from Vercel to Render.

## 1. Web Service Migration (The App)

We have created a `render.yaml` file in your project root. This is a "Blueprint" that tells Render how to deploy your app.

### Option A: Use the Blueprint (Recommended)
1. Push your code to GitHub/GitLab.
2. Go to [Render Dashboard](https://dashboard.render.com/).
3. Click **New +** -> **Blueprint**.
4. Connect your repository.
5. Render will detect the `render.yaml`.
6. You will be prompted to enter the values for your environment variables:
   - `NEXT_PUBLIC_PAYPAL_CLIENT_ID`: (From your .env.local)
   - `MONGODB_URI`: (Your MongoDB connection string)
   - `SESSION_SECRET`: (Render will generate one for you, or you can paste yours)

### Option B: Manual Setup
1. Go to [Render Dashboard](https://dashboard.render.com/).
2. Click **New +** -> **Web Service**.
3. Connect your repository.
4. Settings:
   - **Name**: `roblox-script-shop`
   - **Runtime**: `Node`
   - **Build Command**: `npm install && npm run build`
   - **Start Command**: `npm start`
5. **Environment Variables**:
   Add the following variables:
   - `NEXT_PUBLIC_PAYPAL_CLIENT_ID`
   - `MONGODB_URI`
   - `SESSION_SECRET`

## 2. Database Migration (MongoDB)

You mentioned you want to change from "MongoDB Cloud" (Atlas) to Render.

**Note:** Render does not have a native "Managed MongoDB" service like they do for PostgreSQL. You have two main options:

### Option 1: Keep using MongoDB Atlas (Recommended)
You can simply connect your Render app to your existing MongoDB Atlas database. This is the easiest and most stable approach.
- Ensure your `MONGODB_URI` in Render is set to your Atlas connection string.
- Make sure your Atlas "Network Access" allows connections from anywhere (`0.0.0.0/0`) since Render IPs are dynamic, or whitelist Render's static IPs if you upgrade to a paid plan.

### Option 2: Self-host MongoDB on Render
If you strictly want everything on Render, you must deploy MongoDB as a Docker service backed by a persistent disk.
**Warning:** This is not managed. You are responsible for backups, updates, and security.

To do this, you would add a private service to your `render.yaml`:

```yaml
  - type: pbserv
    name: mongodb
    env: docker
    repo: https://github.com/render-examples/mongodb
    disk:
      name: data
      mountPath: /data/db
      sizeGB: 10
```

*We recommend Option 1 (Atlas) for production reliability.*

## 3. Verify Deployment
Once deployed:
1. Check the **Logs** tab in Render to ensure the build succeeded.
2. Verify the app starts and connects to the database (you will see "Connected to Database" logs if you have them, or just test the app).
