# Migrating to GitHub & Hosting Strategy

## ⚠️ Important Limitations
Your website (`roblox-script-shop`) is a **Dynamic Application**.
- It uses a **Database** (MongoDB/Mongoose).
- It uses **API Routes** (`/api/products`, `/api/submissions`).
- It has server-side logic for authentication and checkout.

**GitHub Pages ONLY supports Static Websites** (HTML/CSS/JS). It cannot host your database or run your API routes. If you deploy this code to GitHub Pages, the checkout and product loading will stop working.

## Recommended Solution
**Keep hosting on Vercel** (which is free for hobby use and supports your database) but **store your code on GitHub** for safety and version control.

## Step-by-Step Guide

### 1. Install Git
Since Git is not currently installed on your computer, you need to install it:
1. Download Git from [git-scm.com/downloads](https://git-scm.com/downloads).
2. Install it (use default settings).
3. Restart your computer (or close/reopen your terminal).

### 2. Create a GitHub Repository
1. Log in to [GitHub.com](https://github.com).
2. Click the **+** icon in the top right and select **New repository**.
3. Name it `roblox-script-shop`.
4. Make it **Public** or **Private** (Private is safer if you have secrets, though you should use `.env` files).
5. Click **Create repository**.

### 3. Push Your Code
Open your terminal (Command Prompt or PowerShell) in this folder (`C:\Users\PC\Desktop\SHOP`) and run these commands one by one:

```bash
# Initialize the repository
git init

# Add all files
git add .

# Save the changes
git commit -m "Initial backup"

# Rename branch to main
git branch -M main

# Link to your new GitHub repo (Replace URL with your actual repo URL)
git remote add origin https://github.com/YOUR_USERNAME/roblox-script-shop.git

# Push the code
git push -u origin main
```

### 4. Connect Vercel to GitHub (Optional but Recommended)
1. Go to your [Vercel Dashboard](https://vercel.com/dashboard).
2. Select your project.
3. Go to **Settings** > **Git**.
4. Click **Connect** and select your new GitHub repository.
5. Now, every time you push code to GitHub, Vercel will automatically redeploy your site!

## Summary
- **Code Storage**: GitHub (Safe, Version Controlled)
- **Live Hosting**: Vercel (Free, Supports Database/API)
