"use strict";
/*
 * ATTENTION: An "eval-source-map" devtool has been used.
 * This devtool is neither made for production nor for readable output files.
 * It uses "eval()" calls to create a separate source file with attached SourceMaps in the browser devtools.
 * If you are trying to read the output file, select a different devtool (https://webpack.js.org/configuration/devtool/)
 * or disable the default devtool with "devtool: false".
 * If you are looking for production-ready output files, see mode: "production" (https://webpack.js.org/configuration/mode/).
 */
exports.id = "vendor-chunks/@paypal";
exports.ids = ["vendor-chunks/@paypal"];
exports.modules = {

/***/ "(ssr)/./node_modules/@paypal/react-paypal-js/dist/esm/react-paypal-js.js":
/*!**************************************************************************!*\
  !*** ./node_modules/@paypal/react-paypal-js/dist/esm/react-paypal-js.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   BraintreePayPalButtons: () => (/* binding */ BraintreePayPalButtons),\n/* harmony export */   DISPATCH_ACTION: () => (/* binding */ DISPATCH_ACTION),\n/* harmony export */   FUNDING: () => (/* binding */ FUNDING),\n/* harmony export */   PAYPAL_HOSTED_FIELDS_TYPES: () => (/* binding */ PAYPAL_HOSTED_FIELDS_TYPES),\n/* harmony export */   PayPalButtons: () => (/* binding */ PayPalButtons),\n/* harmony export */   PayPalCVVField: () => (/* binding */ PayPalCVVField),\n/* harmony export */   PayPalCardFieldsContext: () => (/* binding */ PayPalCardFieldsContext),\n/* harmony export */   PayPalCardFieldsForm: () => (/* binding */ PayPalCardFieldsForm),\n/* harmony export */   PayPalCardFieldsProvider: () => (/* binding */ PayPalCardFieldsProvider),\n/* harmony export */   PayPalExpiryField: () => (/* binding */ PayPalExpiryField),\n/* harmony export */   PayPalHostedField: () => (/* binding */ PayPalHostedField),\n/* harmony export */   PayPalHostedFieldsProvider: () => (/* binding */ PayPalHostedFieldsProvider),\n/* harmony export */   PayPalMarks: () => (/* binding */ PayPalMarks),\n/* harmony export */   PayPalMessages: () => (/* binding */ PayPalMessages),\n/* harmony export */   PayPalNameField: () => (/* binding */ PayPalNameField),\n/* harmony export */   PayPalNumberField: () => (/* binding */ PayPalNumberField),\n/* harmony export */   PayPalScriptProvider: () => (/* binding */ PayPalScriptProvider),\n/* harmony export */   SCRIPT_LOADING_STATE: () => (/* binding */ SCRIPT_LOADING_STATE),\n/* harmony export */   ScriptContext: () => (/* binding */ ScriptContext),\n/* harmony export */   destroySDKScript: () => (/* binding */ destroySDKScript),\n/* harmony export */   getScriptID: () => (/* binding */ getScriptID),\n/* harmony export */   scriptReducer: () => (/* binding */ scriptReducer),\n/* harmony export */   usePayPalCardFields: () => (/* binding */ usePayPalCardFields),\n/* harmony export */   usePayPalHostedFields: () => (/* binding */ usePayPalHostedFields),\n/* harmony export */   usePayPalScriptReducer: () => (/* binding */ usePayPalScriptReducer),\n/* harmony export */   useScriptProviderContext: () => (/* binding */ useScriptProviderContext)\n/* harmony export */ });\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ \"(ssr)/./node_modules/next/dist/server/future/route-modules/app-page/vendored/ssr/react.js\");\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);\n/*!\n * react-paypal-js v8.9.2 (2025-10-02T20:17:55.069Z)\n * Copyright 2020-present, PayPal, Inc. All rights reserved.\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * https://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n\n/**\n * Enum for the SDK script resolve status,\n *\n * @enum {string}\n */\nvar SCRIPT_LOADING_STATE;\n(function (SCRIPT_LOADING_STATE) {\n  SCRIPT_LOADING_STATE[\"INITIAL\"] = \"initial\";\n  SCRIPT_LOADING_STATE[\"PENDING\"] = \"pending\";\n  SCRIPT_LOADING_STATE[\"REJECTED\"] = \"rejected\";\n  SCRIPT_LOADING_STATE[\"RESOLVED\"] = \"resolved\";\n})(SCRIPT_LOADING_STATE || (SCRIPT_LOADING_STATE = {}));\n/**\n * Enum for the PayPalScriptProvider context dispatch actions\n *\n * @enum {string}\n */\nvar DISPATCH_ACTION;\n(function (DISPATCH_ACTION) {\n  DISPATCH_ACTION[\"LOADING_STATUS\"] = \"setLoadingStatus\";\n  DISPATCH_ACTION[\"RESET_OPTIONS\"] = \"resetOptions\";\n  DISPATCH_ACTION[\"SET_BRAINTREE_INSTANCE\"] = \"braintreeInstance\";\n})(DISPATCH_ACTION || (DISPATCH_ACTION = {}));\n/**\n * Enum for all the available hosted fields\n *\n * @enum {string}\n */\nvar PAYPAL_HOSTED_FIELDS_TYPES;\n(function (PAYPAL_HOSTED_FIELDS_TYPES) {\n  PAYPAL_HOSTED_FIELDS_TYPES[\"NUMBER\"] = \"number\";\n  PAYPAL_HOSTED_FIELDS_TYPES[\"CVV\"] = \"cvv\";\n  PAYPAL_HOSTED_FIELDS_TYPES[\"EXPIRATION_DATE\"] = \"expirationDate\";\n  PAYPAL_HOSTED_FIELDS_TYPES[\"EXPIRATION_MONTH\"] = \"expirationMonth\";\n  PAYPAL_HOSTED_FIELDS_TYPES[\"EXPIRATION_YEAR\"] = \"expirationYear\";\n  PAYPAL_HOSTED_FIELDS_TYPES[\"POSTAL_CODE\"] = \"postalCode\";\n})(PAYPAL_HOSTED_FIELDS_TYPES || (PAYPAL_HOSTED_FIELDS_TYPES = {}));\nvar __assign = function () {\n  __assign = Object.assign || function __assign(t) {\n    for (var s, i = 1, n = arguments.length; i < n; i++) {\n      s = arguments[i];\n      for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p)) t[p] = s[p];\n    }\n    return t;\n  };\n  return __assign.apply(this, arguments);\n};\nfunction __rest$1(s, e) {\n  var t = {};\n  for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0) t[p] = s[p];\n  if (s != null && typeof Object.getOwnPropertySymbols === \"function\") for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {\n    if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i])) t[p[i]] = s[p[i]];\n  }\n  return t;\n}\nfunction __spreadArray(to, from, pack) {\n  if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {\n    if (ar || !(i in from)) {\n      if (!ar) ar = Array.prototype.slice.call(from, 0, i);\n      ar[i] = from[i];\n    }\n  }\n  return to.concat(ar || Array.prototype.slice.call(from));\n}\ntypeof SuppressedError === \"function\" ? SuppressedError : function (error, suppressed, message) {\n  var e = new Error(message);\n  return e.name = \"SuppressedError\", e.error = error, e.suppressed = suppressed, e;\n};\n\n/*********************************************\n * Common reference to the script identifier *\n *********************************************/\n// keep this script id value in kebab-case format\nvar SCRIPT_ID = \"data-react-paypal-script-id\";\nvar SDK_SETTINGS = {\n  DATA_CLIENT_TOKEN: \"dataClientToken\",\n  DATA_JS_SDK_LIBRARY: \"dataJsSdkLibrary\",\n  DATA_LIBRARY_VALUE: \"react-paypal-js\",\n  DATA_NAMESPACE: \"dataNamespace\",\n  DATA_SDK_INTEGRATION_SOURCE: \"dataSdkIntegrationSource\",\n  DATA_USER_ID_TOKEN: \"dataUserIdToken\"\n};\nvar LOAD_SCRIPT_ERROR = \"Failed to load the PayPal JS SDK script.\";\n/****************************\n * Braintree error messages *\n ****************************/\nvar EMPTY_BRAINTREE_AUTHORIZATION_ERROR_MESSAGE = \"Invalid authorization data. Use dataClientToken or dataUserIdToken to authorize.\";\nvar braintreeVersion = \"3.117.0\";\nvar BRAINTREE_SOURCE = \"https://js.braintreegateway.com/web/\".concat(braintreeVersion, \"/js/client.min.js\");\nvar BRAINTREE_PAYPAL_CHECKOUT_SOURCE = \"https://js.braintreegateway.com/web/\".concat(braintreeVersion, \"/js/paypal-checkout.min.js\");\n/*********************\n * PayPal namespaces *\n *********************/\nvar DEFAULT_PAYPAL_NAMESPACE = \"paypal\";\nvar DEFAULT_BRAINTREE_NAMESPACE = \"braintree\";\n/*****************\n * Hosted Fields *\n *****************/\nvar HOSTED_FIELDS_CHILDREN_ERROR = \"To use HostedFields you must use it with at least 3 children with types: [number, cvv, expirationDate] includes\";\nvar HOSTED_FIELDS_DUPLICATE_CHILDREN_ERROR = \"Cannot use duplicate HostedFields as children\";\n/*******************\n * Script Provider *\n *******************/\nvar SCRIPT_PROVIDER_REDUCER_ERROR = \"usePayPalScriptReducer must be used within a PayPalScriptProvider\";\nvar CARD_FIELDS_DUPLICATE_CHILDREN_ERROR = \"Cannot use duplicate CardFields as children\";\nvar CARD_FIELDS_CONTEXT_ERROR = \"Individual CardFields must be rendered inside the PayPalCardFieldsProvider\";\n\n/**\n * Get the namespace from the window in the browser\n * this is useful to get the paypal object from window\n * after load PayPal SDK script\n *\n * @param namespace the name space to return\n * @returns the namespace if exists or undefined otherwise\n */\nfunction getPayPalWindowNamespace$1(namespace) {\n  if (namespace === void 0) {\n    namespace = DEFAULT_PAYPAL_NAMESPACE;\n  }\n  // eslint-disable-next-line @typescript-eslint/no-explicit-any\n  return window[namespace];\n}\n/**\n * Get a namespace from the window in the browser\n * this is useful to get the braintree from window\n * after load Braintree script\n *\n * @param namespace the name space to return\n * @returns the namespace if exists or undefined otherwise\n */\nfunction getBraintreeWindowNamespace(namespace) {\n  if (namespace === void 0) {\n    namespace = DEFAULT_BRAINTREE_NAMESPACE;\n  }\n  // eslint-disable-next-line @typescript-eslint/no-explicit-any\n  return window[namespace];\n}\n/**\n * Creates a string hash code based on the string argument\n *\n * @param str the source input string to hash\n * @returns string hash code\n */\nfunction hashStr(str) {\n  var hash = \"\";\n  for (var i = 0; i < str.length; i++) {\n    var total = str[i].charCodeAt(0) * i;\n    if (str[i + 1]) {\n      total += str[i + 1].charCodeAt(0) * (i - 1);\n    }\n    hash += String.fromCharCode(97 + Math.abs(total) % 26);\n  }\n  return hash;\n}\nfunction generateErrorMessage(_a) {\n  var reactComponentName = _a.reactComponentName,\n    sdkComponentKey = _a.sdkComponentKey,\n    _b = _a.sdkRequestedComponents,\n    sdkRequestedComponents = _b === void 0 ? \"\" : _b,\n    _c = _a.sdkDataNamespace,\n    sdkDataNamespace = _c === void 0 ? DEFAULT_PAYPAL_NAMESPACE : _c;\n  var requiredOptionCapitalized = sdkComponentKey.charAt(0).toUpperCase().concat(sdkComponentKey.substring(1));\n  var errorMessage = \"Unable to render <\".concat(reactComponentName, \" /> because window.\").concat(sdkDataNamespace, \".\").concat(requiredOptionCapitalized, \" is undefined.\");\n  // The JS SDK only loads the buttons component by default.\n  // All other components like messages and marks must be requested using the \"components\" query parameter\n  var requestedComponents = typeof sdkRequestedComponents === \"string\" ? sdkRequestedComponents : sdkRequestedComponents.join(\",\");\n  if (!requestedComponents.includes(sdkComponentKey)) {\n    var expectedComponents = [requestedComponents, sdkComponentKey].filter(Boolean).join();\n    errorMessage += \"\\nTo fix the issue, add '\".concat(sdkComponentKey, \"' to the list of components passed to the parent PayPalScriptProvider:\") + \"\\n`<PayPalScriptProvider options={{ components: '\".concat(expectedComponents, \"'}}>`.\");\n  }\n  return errorMessage;\n}\n\n/**\n * Generate a new random identifier for react-paypal-js\n *\n * @returns the {@code string} containing the random library name\n */\nfunction getScriptID(options) {\n  // exclude the data-react-paypal-script-id value from the options hash\n  var _a = options,\n    _b = SCRIPT_ID;\n  _a[_b];\n  var paypalScriptOptions = __rest$1(_a, [_b + \"\"]);\n  return \"react-paypal-js-\".concat(hashStr(JSON.stringify(paypalScriptOptions)));\n}\n/**\n * Destroy the PayPal SDK from the document page\n *\n * @param reactPayPalScriptID the script identifier\n */\nfunction destroySDKScript(reactPayPalScriptID) {\n  var scriptNode = self.document.querySelector(\"script[\".concat(SCRIPT_ID, \"=\\\"\").concat(reactPayPalScriptID, \"\\\"]\"));\n  if (scriptNode === null || scriptNode === void 0 ? void 0 : scriptNode.parentNode) {\n    scriptNode.parentNode.removeChild(scriptNode);\n  }\n}\n/**\n * Reducer function to handle complex state changes on the context\n *\n * @param state  the current state on the context object\n * @param action the action to be executed on the previous state\n * @returns a the same state if the action wasn't found, or a new state otherwise\n */\nfunction scriptReducer(state, action) {\n  var _a, _b;\n  switch (action.type) {\n    case DISPATCH_ACTION.LOADING_STATUS:\n      if (typeof action.value === \"object\") {\n        return __assign(__assign({}, state), {\n          loadingStatus: action.value.state,\n          loadingStatusErrorMessage: action.value.message\n        });\n      }\n      return __assign(__assign({}, state), {\n        loadingStatus: action.value\n      });\n    case DISPATCH_ACTION.RESET_OPTIONS:\n      // destroy existing script to make sure only one script loads at a time\n      destroySDKScript(state.options[SCRIPT_ID]);\n      return __assign(__assign({}, state), {\n        loadingStatus: SCRIPT_LOADING_STATE.PENDING,\n        options: __assign(__assign((_a = {}, _a[SDK_SETTINGS.DATA_SDK_INTEGRATION_SOURCE] = SDK_SETTINGS.DATA_LIBRARY_VALUE, _a), action.value), (_b = {}, _b[SCRIPT_ID] = \"\".concat(getScriptID(action.value)), _b))\n      });\n    case DISPATCH_ACTION.SET_BRAINTREE_INSTANCE:\n      return __assign(__assign({}, state), {\n        braintreePayPalCheckoutInstance: action.value\n      });\n    default:\n      {\n        return state;\n      }\n  }\n}\n// Create the React context to use in the script provider component\nvar ScriptContext = (0,react__WEBPACK_IMPORTED_MODULE_0__.createContext)(null);\n\n/**\n * Check if the context is valid and ready to dispatch actions.\n *\n * @param scriptContext the result of connecting to the context provider\n * @returns strict context avoiding null values in the type\n */\nfunction validateReducer(scriptContext) {\n  if (typeof (scriptContext === null || scriptContext === void 0 ? void 0 : scriptContext.dispatch) === \"function\" && scriptContext.dispatch.length !== 0) {\n    return scriptContext;\n  }\n  throw new Error(SCRIPT_PROVIDER_REDUCER_ERROR);\n}\n/**\n * Check if the dataClientToken or the dataUserIdToken are\n * set in the options of the context.\n * @type dataClientToken is use to pass a client token\n * @type dataUserIdToken is use to pass a client tokenization key\n *\n * @param scriptContext the result of connecting to the context provider\n * @throws an {@link Error} if both dataClientToken and the dataUserIdToken keys are null or undefined\n * @returns strict context if one of the keys are defined\n */\nvar validateBraintreeAuthorizationData = function (scriptContext) {\n  var _a, _b;\n  if (!((_a = scriptContext === null || scriptContext === void 0 ? void 0 : scriptContext.options) === null || _a === void 0 ? void 0 : _a[SDK_SETTINGS.DATA_CLIENT_TOKEN]) && !((_b = scriptContext === null || scriptContext === void 0 ? void 0 : scriptContext.options) === null || _b === void 0 ? void 0 : _b[SDK_SETTINGS.DATA_USER_ID_TOKEN])) {\n    throw new Error(EMPTY_BRAINTREE_AUTHORIZATION_ERROR_MESSAGE);\n  }\n  return scriptContext;\n};\n\n/**\n * Custom hook to get access to the Script context and\n * dispatch actions to modify the state on the {@link ScriptProvider} component\n *\n * @returns a tuple containing the state of the context and\n * a dispatch function to modify the state\n */\nfunction usePayPalScriptReducer() {\n  var scriptContext = validateReducer((0,react__WEBPACK_IMPORTED_MODULE_0__.useContext)(ScriptContext));\n  var derivedStatusContext = __assign(__assign({}, scriptContext), {\n    isInitial: scriptContext.loadingStatus === SCRIPT_LOADING_STATE.INITIAL,\n    isPending: scriptContext.loadingStatus === SCRIPT_LOADING_STATE.PENDING,\n    isResolved: scriptContext.loadingStatus === SCRIPT_LOADING_STATE.RESOLVED,\n    isRejected: scriptContext.loadingStatus === SCRIPT_LOADING_STATE.REJECTED\n  });\n  return [derivedStatusContext, scriptContext.dispatch];\n}\n/**\n * Custom hook to get access to the ScriptProvider context\n *\n * @returns the latest state of the context\n */\nfunction useScriptProviderContext() {\n  var scriptContext = validateBraintreeAuthorizationData(validateReducer((0,react__WEBPACK_IMPORTED_MODULE_0__.useContext)(ScriptContext)));\n  return [scriptContext, scriptContext.dispatch];\n}\n\n// Create the React context to use in the PayPal hosted fields provider\nvar PayPalHostedFieldsContext = (0,react__WEBPACK_IMPORTED_MODULE_0__.createContext)({});\n\n/**\n * Custom hook to get access to the PayPal Hosted Fields instance.\n * The instance represent the returned object after the render process\n * With this object a user can submit the fields and dynamically modify the cards\n *\n * @returns the hosted fields instance if is available in the component\n */\nfunction usePayPalHostedFields() {\n  return (0,react__WEBPACK_IMPORTED_MODULE_0__.useContext)(PayPalHostedFieldsContext);\n}\nfunction useProxyProps(props) {\n  var proxyRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(new Proxy({}, {\n    get: function (target, prop, receiver) {\n      /**\n       *\n       * If target[prop] is a function, return a function that accesses\n       * this function off the target object. We can mutate the target with\n       * new copies of this function without having to re-render the\n       * SDK components to pass new callbacks.\n       *\n       * */\n      if (typeof target[prop] === \"function\") {\n        return function () {\n          var args = [];\n          for (var _i = 0; _i < arguments.length; _i++) {\n            args[_i] = arguments[_i];\n          }\n          // eslint-disable-next-line @typescript-eslint/ban-types\n          return target[prop].apply(target, args);\n        };\n      }\n      return Reflect.get(target, prop, receiver);\n    }\n  }));\n  proxyRef.current = Object.assign(proxyRef.current, props);\n  return proxyRef.current;\n}\n\n/**\nThis `<PayPalButtons />` component supports rendering [buttons](https://developer.paypal.com/docs/business/javascript-sdk/javascript-sdk-reference/#buttons) for PayPal, Venmo, and alternative payment methods.\nIt relies on the `<PayPalScriptProvider />` parent component for managing state related to loading the JS SDK script.\n*/\nvar PayPalButtons = function (_a) {\n  var _b;\n  var _c = _a.className,\n    className = _c === void 0 ? \"\" : _c,\n    _d = _a.disabled,\n    disabled = _d === void 0 ? false : _d,\n    children = _a.children,\n    _e = _a.forceReRender,\n    forceReRender = _e === void 0 ? [] : _e,\n    buttonProps = __rest$1(_a, [\"className\", \"disabled\", \"children\", \"forceReRender\"]);\n  var isDisabledStyle = disabled ? {\n    opacity: 0.38\n  } : {};\n  var classNames = \"\".concat(className, \" \").concat(disabled ? \"paypal-buttons-disabled\" : \"\").trim();\n  var buttonsContainerRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);\n  var buttons = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);\n  var proxyProps = useProxyProps(buttonProps);\n  var _f = usePayPalScriptReducer()[0],\n    isResolved = _f.isResolved,\n    options = _f.options;\n  var _g = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(null),\n    initActions = _g[0],\n    setInitActions = _g[1];\n  var _h = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(true),\n    isEligible = _h[0],\n    setIsEligible = _h[1];\n  var _j = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(null),\n    setErrorState = _j[1];\n  function closeButtonsComponent() {\n    if (buttons.current !== null) {\n      buttons.current.close().catch(function () {\n        // ignore errors when closing the component\n      });\n    }\n  }\n  if ((_b = buttons.current) === null || _b === void 0 ? void 0 : _b.updateProps) {\n    buttons.current.updateProps({\n      message: buttonProps.message\n    });\n  }\n  // useEffect hook for rendering the buttons\n  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(function () {\n    // verify the sdk script has successfully loaded\n    if (isResolved === false) {\n      return closeButtonsComponent;\n    }\n    var paypalWindowNamespace = getPayPalWindowNamespace$1(options.dataNamespace);\n    // verify dependency on window object\n    if (paypalWindowNamespace === undefined || paypalWindowNamespace.Buttons === undefined) {\n      setErrorState(function () {\n        throw new Error(generateErrorMessage({\n          reactComponentName: PayPalButtons.displayName,\n          sdkComponentKey: \"buttons\",\n          sdkRequestedComponents: options.components,\n          sdkDataNamespace: options[SDK_SETTINGS.DATA_NAMESPACE]\n        }));\n      });\n      return closeButtonsComponent;\n    }\n    var decoratedOnInit = function (data, actions) {\n      setInitActions(actions);\n      if (typeof buttonProps.onInit === \"function\") {\n        buttonProps.onInit(data, actions);\n      }\n    };\n    try {\n      buttons.current = paypalWindowNamespace.Buttons(__assign(__assign({}, proxyProps), {\n        onInit: decoratedOnInit\n      }));\n    } catch (err) {\n      return setErrorState(function () {\n        throw new Error(\"Failed to render <PayPalButtons /> component. Failed to initialize:  \".concat(err));\n      });\n    }\n    // only render the button when eligible\n    if (buttons.current.isEligible() === false) {\n      setIsEligible(false);\n      return closeButtonsComponent;\n    }\n    if (!buttonsContainerRef.current) {\n      return closeButtonsComponent;\n    }\n    buttons.current.render(buttonsContainerRef.current).catch(function (err) {\n      // component failed to render, possibly because it was closed or destroyed.\n      if (buttonsContainerRef.current === null || buttonsContainerRef.current.children.length === 0) {\n        // paypal buttons container is no longer in the DOM, we can safely ignore the error\n        return;\n      }\n      // paypal buttons container is still in the DOM\n      setErrorState(function () {\n        throw new Error(\"Failed to render <PayPalButtons /> component. \".concat(err));\n      });\n    });\n    return closeButtonsComponent;\n    // eslint-disable-next-line react-hooks/exhaustive-deps\n  }, __spreadArray(__spreadArray([isResolved], forceReRender, true), [buttonProps.fundingSource], false));\n  // useEffect hook for managing disabled state\n  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(function () {\n    if (initActions === null) {\n      return;\n    }\n    if (disabled === true) {\n      initActions.disable().catch(function () {\n        // ignore errors when disabling the component\n      });\n    } else {\n      initActions.enable().catch(function () {\n        // ignore errors when enabling the component\n      });\n    }\n  }, [disabled, initActions]);\n  return react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, isEligible ? react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"div\", {\n    ref: buttonsContainerRef,\n    style: isDisabledStyle,\n    className: classNames\n  }) : children);\n};\nPayPalButtons.displayName = \"PayPalButtons\";\nfunction __rest(s, e) {\n  var t = {};\n  for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0) t[p] = s[p];\n  if (s != null && typeof Object.getOwnPropertySymbols === \"function\") for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {\n    if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i])) t[p[i]] = s[p[i]];\n  }\n  return t;\n}\ntypeof SuppressedError === \"function\" ? SuppressedError : function (error, suppressed, message) {\n  var e = new Error(message);\n  return e.name = \"SuppressedError\", e.error = error, e.suppressed = suppressed, e;\n};\nfunction findScript(url, attributes) {\n  var currentScript = document.querySelector(\"script[src=\\\"\".concat(url, \"\\\"]\"));\n  if (currentScript === null) return null;\n  var nextScript = createScriptElement(url, attributes);\n  var currentScriptClone = currentScript.cloneNode();\n  delete currentScriptClone.dataset.uidAuto;\n  if (Object.keys(currentScriptClone.dataset).length !== Object.keys(nextScript.dataset).length) {\n    return null;\n  }\n  var isExactMatch = true;\n  Object.keys(currentScriptClone.dataset).forEach(function (key) {\n    if (currentScriptClone.dataset[key] !== nextScript.dataset[key]) {\n      isExactMatch = false;\n    }\n  });\n  return isExactMatch ? currentScript : null;\n}\nfunction insertScriptElement(_a) {\n  var url = _a.url,\n    attributes = _a.attributes,\n    onSuccess = _a.onSuccess,\n    onError = _a.onError;\n  var newScript = createScriptElement(url, attributes);\n  newScript.onerror = onError;\n  newScript.onload = onSuccess;\n  document.head.insertBefore(newScript, document.head.firstElementChild);\n}\nfunction processOptions(_a) {\n  var customSdkBaseUrl = _a.sdkBaseUrl,\n    environment = _a.environment,\n    options = __rest(_a, [\"sdkBaseUrl\", \"environment\"]);\n  var sdkBaseUrl = customSdkBaseUrl || processSdkBaseUrl(environment);\n  var optionsWithStringIndex = options;\n  var _b = Object.keys(optionsWithStringIndex).filter(function (key) {\n      return typeof optionsWithStringIndex[key] !== \"undefined\" && optionsWithStringIndex[key] !== null && optionsWithStringIndex[key] !== \"\";\n    }).reduce(function (accumulator, key) {\n      var value = optionsWithStringIndex[key].toString();\n      key = camelCaseToKebabCase(key);\n      if (key.substring(0, 4) === \"data\" || key === \"crossorigin\") {\n        accumulator.attributes[key] = value;\n      } else {\n        accumulator.queryParams[key] = value;\n      }\n      return accumulator;\n    }, {\n      queryParams: {},\n      attributes: {}\n    }),\n    queryParams = _b.queryParams,\n    attributes = _b.attributes;\n  if (queryParams[\"merchant-id\"] && queryParams[\"merchant-id\"].indexOf(\",\") !== -1) {\n    attributes[\"data-merchant-id\"] = queryParams[\"merchant-id\"];\n    queryParams[\"merchant-id\"] = \"*\";\n  }\n  return {\n    url: \"\".concat(sdkBaseUrl, \"?\").concat(objectToQueryString(queryParams)),\n    attributes: attributes\n  };\n}\nfunction camelCaseToKebabCase(str) {\n  var replacer = function (match, indexOfMatch) {\n    return (indexOfMatch ? \"-\" : \"\") + match.toLowerCase();\n  };\n  return str.replace(/[A-Z]+(?![a-z])|[A-Z]/g, replacer);\n}\nfunction objectToQueryString(params) {\n  var queryString = \"\";\n  Object.keys(params).forEach(function (key) {\n    if (queryString.length !== 0) queryString += \"&\";\n    queryString += key + \"=\" + params[key];\n  });\n  return queryString;\n}\nfunction processSdkBaseUrl(environment) {\n  return environment === \"sandbox\" ? \"https://www.sandbox.paypal.com/sdk/js\" : \"https://www.paypal.com/sdk/js\";\n}\nfunction createScriptElement(url, attributes) {\n  if (attributes === void 0) {\n    attributes = {};\n  }\n  var newScript = document.createElement(\"script\");\n  newScript.src = url;\n  Object.keys(attributes).forEach(function (key) {\n    newScript.setAttribute(key, attributes[key]);\n    if (key === \"data-csp-nonce\") {\n      newScript.setAttribute(\"nonce\", attributes[\"data-csp-nonce\"]);\n    }\n  });\n  return newScript;\n}\nfunction loadScript(options, PromisePonyfill) {\n  if (PromisePonyfill === void 0) {\n    PromisePonyfill = Promise;\n  }\n  validateArguments(options, PromisePonyfill);\n  if (typeof document === \"undefined\") return PromisePonyfill.resolve(null);\n  var _a = processOptions(options),\n    url = _a.url,\n    attributes = _a.attributes;\n  var namespace = attributes[\"data-namespace\"] || \"paypal\";\n  var existingWindowNamespace = getPayPalWindowNamespace(namespace);\n  if (!attributes[\"data-js-sdk-library\"]) {\n    attributes[\"data-js-sdk-library\"] = \"paypal-js\";\n  }\n  if (findScript(url, attributes) && existingWindowNamespace) {\n    return PromisePonyfill.resolve(existingWindowNamespace);\n  }\n  return loadCustomScript({\n    url: url,\n    attributes: attributes\n  }, PromisePonyfill).then(function () {\n    var newWindowNamespace = getPayPalWindowNamespace(namespace);\n    if (newWindowNamespace) {\n      return newWindowNamespace;\n    }\n    throw new Error(\"The window.\".concat(namespace, \" global variable is not available.\"));\n  });\n}\nfunction loadCustomScript(options, PromisePonyfill) {\n  if (PromisePonyfill === void 0) {\n    PromisePonyfill = Promise;\n  }\n  validateArguments(options, PromisePonyfill);\n  var url = options.url,\n    attributes = options.attributes;\n  if (typeof url !== \"string\" || url.length === 0) {\n    throw new Error(\"Invalid url.\");\n  }\n  if (typeof attributes !== \"undefined\" && typeof attributes !== \"object\") {\n    throw new Error(\"Expected attributes to be an object.\");\n  }\n  return new PromisePonyfill(function (resolve, reject) {\n    if (typeof document === \"undefined\") return resolve();\n    insertScriptElement({\n      url: url,\n      attributes: attributes,\n      onSuccess: function () {\n        return resolve();\n      },\n      onError: function () {\n        var defaultError = new Error(\"The script \\\"\".concat(url, \"\\\" failed to load. Check the HTTP status code and response body in DevTools to learn more.\"));\n        return reject(defaultError);\n      }\n    });\n  });\n}\nfunction getPayPalWindowNamespace(namespace) {\n  return window[namespace];\n}\nfunction validateArguments(options, PromisePonyfill) {\n  if (typeof options !== \"object\" || options === null) {\n    throw new Error(\"Expected an options object.\");\n  }\n  var environment = options.environment;\n  if (environment && environment !== \"production\" && environment !== \"sandbox\") {\n    throw new Error('The `environment` option must be either \"production\" or \"sandbox\".');\n  }\n  if (typeof PromisePonyfill !== \"undefined\" && typeof PromisePonyfill !== \"function\") {\n    throw new Error(\"Expected PromisePonyfill to be a function.\");\n  }\n}\n\n/**\n * Simple check to determine if the Braintree is a valid namespace.\n *\n * @param braintreeSource the source {@link BraintreeNamespace}\n * @returns a boolean representing if the namespace is valid.\n */\nvar isValidBraintreeNamespace = function (braintreeSource) {\n  var _a, _b;\n  if (typeof ((_a = braintreeSource === null || braintreeSource === void 0 ? void 0 : braintreeSource.client) === null || _a === void 0 ? void 0 : _a.create) !== \"function\" && typeof ((_b = braintreeSource === null || braintreeSource === void 0 ? void 0 : braintreeSource.paypalCheckout) === null || _b === void 0 ? void 0 : _b.create) !== \"function\") {\n    throw new Error(\"The braintreeNamespace property is not a valid BraintreeNamespace type.\");\n  }\n  return true;\n};\n/**\n * Use `actions.braintree` to provide an interface for the paypalCheckoutInstance\n * through the createOrder, createBillingAgreement and onApprove callbacks\n *\n * @param braintreeButtonProps the component button options\n * @returns a new copy of the component button options casted as {@link PayPalButtonsComponentProps}\n */\nvar decorateActions = function (buttonProps, payPalCheckoutInstance) {\n  var createOrderRef = buttonProps.createOrder;\n  var createBillingAgreementRef = buttonProps.createBillingAgreement;\n  var onApproveRef = buttonProps.onApprove;\n  if (typeof createOrderRef === \"function\") {\n    buttonProps.createOrder = function (data, actions) {\n      return createOrderRef(data, __assign(__assign({}, actions), {\n        braintree: payPalCheckoutInstance\n      }));\n    };\n  }\n  if (typeof createBillingAgreementRef === \"function\") {\n    buttonProps.createBillingAgreement = function (data, actions) {\n      return createBillingAgreementRef(data, __assign(__assign({}, actions), {\n        braintree: payPalCheckoutInstance\n      }));\n    };\n  }\n  if (typeof onApproveRef === \"function\") {\n    buttonProps.onApprove = function (data, actions) {\n      return onApproveRef(data, __assign(__assign({}, actions), {\n        braintree: payPalCheckoutInstance\n      }));\n    };\n  }\n  return __assign({}, buttonProps);\n};\n/**\n * Get the Braintree namespace from the component props.\n * If the prop `braintreeNamespace` is undefined will try to load it from the CDN.\n * This function allows users to set the braintree manually on the `BraintreePayPalButtons` component.\n *\n * Use case can be for example legacy sites using AMD/UMD modules,\n * trying to integrate the `BraintreePayPalButtons` component.\n * If we attempt to load the Braintree from the CDN won't define the braintree namespace.\n * This happens because the braintree script is an UMD module.\n * After detecting the AMD on the global scope will create an anonymous module using `define`\n * and the `BraintreePayPalButtons` won't be able to get access to the `window.braintree` namespace\n * from the global context.\n *\n * @param braintreeSource the source {@link BraintreeNamespace}\n * @returns the {@link BraintreeNamespace}\n */\nvar getBraintreeNamespace = function (braintreeSource) {\n  if (braintreeSource && isValidBraintreeNamespace(braintreeSource)) {\n    return Promise.resolve(braintreeSource);\n  }\n  return Promise.all([loadCustomScript({\n    url: BRAINTREE_SOURCE\n  }), loadCustomScript({\n    url: BRAINTREE_PAYPAL_CHECKOUT_SOURCE\n  })]).then(function () {\n    return getBraintreeWindowNamespace();\n  });\n};\n\n/**\nThis `<BraintreePayPalButtons />` component renders the [Braintree PayPal Buttons](https://developer.paypal.com/braintree/docs/guides/paypal/overview) for Braintree Merchants.\nIt relies on the `<PayPalScriptProvider />` parent component for managing state related to loading the JS SDK script.\n\nNote: You are able to make your integration using the client token or using the tokenization key.\n\n- To use the client token integration set the key `dataClientToken` in the `PayPayScriptProvider` component's options.\n- To use the tokenization key integration set the key `dataUserIdToken` in the `PayPayScriptProvider` component's options.\n*/\nvar BraintreePayPalButtons = function (_a) {\n  var _b = _a.className,\n    className = _b === void 0 ? \"\" : _b,\n    _c = _a.disabled,\n    disabled = _c === void 0 ? false : _c,\n    children = _a.children,\n    _d = _a.forceReRender,\n    forceReRender = _d === void 0 ? [] : _d,\n    braintreeNamespace = _a.braintreeNamespace,\n    merchantAccountId = _a.merchantAccountId,\n    buttonProps = __rest$1(_a, [\"className\", \"disabled\", \"children\", \"forceReRender\", \"braintreeNamespace\", \"merchantAccountId\"]);\n  var _e = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(null),\n    setErrorState = _e[1];\n  var _f = useScriptProviderContext(),\n    providerContext = _f[0],\n    dispatch = _f[1];\n  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(function () {\n    getBraintreeNamespace(braintreeNamespace).then(function (braintree) {\n      var clientTokenizationKey = providerContext.options[SDK_SETTINGS.DATA_USER_ID_TOKEN];\n      var clientToken = providerContext.options[SDK_SETTINGS.DATA_CLIENT_TOKEN];\n      return braintree.client.create({\n        authorization: clientTokenizationKey || clientToken\n      }).then(function (clientInstance) {\n        var merchantProp = merchantAccountId ? {\n          merchantAccountId: merchantAccountId\n        } : {};\n        return braintree.paypalCheckout.create(__assign(__assign({}, merchantProp), {\n          client: clientInstance\n        }));\n      }).then(function (paypalCheckoutInstance) {\n        dispatch({\n          type: DISPATCH_ACTION.SET_BRAINTREE_INSTANCE,\n          value: paypalCheckoutInstance\n        });\n      });\n    }).catch(function (err) {\n      setErrorState(function () {\n        throw new Error(\"\".concat(LOAD_SCRIPT_ERROR, \" \").concat(err));\n      });\n    });\n    // eslint-disable-next-line react-hooks/exhaustive-deps\n  }, [providerContext.options]);\n  return react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, providerContext.braintreePayPalCheckoutInstance && react__WEBPACK_IMPORTED_MODULE_0___default().createElement(PayPalButtons, __assign({\n    className: className,\n    disabled: disabled,\n    forceReRender: forceReRender\n  }, decorateActions(buttonProps, providerContext.braintreePayPalCheckoutInstance)), children));\n};\n\n/**\nThe `<PayPalMarks />` component is used for conditionally rendering different payment options using radio buttons.\nThe [Display PayPal Buttons with other Payment Methods guide](https://developer.paypal.com/docs/business/checkout/add-capabilities/buyer-experience/#display-paypal-buttons-with-other-payment-methods) describes this style of integration in detail.\nIt relies on the `<PayPalScriptProvider />` parent component for managing state related to loading the JS SDK script.\n\nThis component can also be configured to use a single funding source similar to the [standalone buttons](https://developer.paypal.com/docs/business/checkout/configure-payments/standalone-buttons/) approach.\nA `FUNDING` object is exported by this library which has a key for every available funding source option.\n*/\nvar PayPalMarks = function (_a) {\n  var _b = _a.className,\n    className = _b === void 0 ? \"\" : _b,\n    children = _a.children,\n    markProps = __rest$1(_a, [\"className\", \"children\"]);\n  var _c = usePayPalScriptReducer()[0],\n    isResolved = _c.isResolved,\n    options = _c.options;\n  var markContainerRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);\n  var _d = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(true),\n    isEligible = _d[0],\n    setIsEligible = _d[1];\n  var _e = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(null),\n    setErrorState = _e[1];\n  /**\n   * Render PayPal Mark into the DOM\n   */\n  var renderPayPalMark = function (mark) {\n    var current = markContainerRef.current;\n    // only render the mark when eligible\n    if (!current || !mark.isEligible()) {\n      return setIsEligible(false);\n    }\n    // Remove any children before render it again\n    if (current.firstChild) {\n      current.removeChild(current.firstChild);\n    }\n    mark.render(current).catch(function (err) {\n      // component failed to render, possibly because it was closed or destroyed.\n      if (current === null || current.children.length === 0) {\n        // paypal marks container is no longer in the DOM, we can safely ignore the error\n        return;\n      }\n      // paypal marks container is still in the DOM\n      setErrorState(function () {\n        throw new Error(\"Failed to render <PayPalMarks /> component. \".concat(err));\n      });\n    });\n  };\n  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(function () {\n    // verify the sdk script has successfully loaded\n    if (isResolved === false) {\n      return;\n    }\n    var paypalWindowNamespace = getPayPalWindowNamespace$1(options[SDK_SETTINGS.DATA_NAMESPACE]);\n    // verify dependency on window object\n    if (paypalWindowNamespace === undefined || paypalWindowNamespace.Marks === undefined) {\n      return setErrorState(function () {\n        throw new Error(generateErrorMessage({\n          reactComponentName: PayPalMarks.displayName,\n          sdkComponentKey: \"marks\",\n          sdkRequestedComponents: options.components,\n          sdkDataNamespace: options[SDK_SETTINGS.DATA_NAMESPACE]\n        }));\n      });\n    }\n    renderPayPalMark(paypalWindowNamespace.Marks(__assign({}, markProps)));\n    // eslint-disable-next-line react-hooks/exhaustive-deps\n  }, [isResolved, markProps.fundingSource]);\n  return react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, isEligible ? react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"div\", {\n    ref: markContainerRef,\n    className: className\n  }) : children);\n};\nPayPalMarks.displayName = \"PayPalMarks\";\n\n/**\nThis `<PayPalMessages />` messages component renders a credit messaging on upstream merchant sites.\nIt relies on the `<PayPalScriptProvider />` parent component for managing state related to loading the JS SDK script.\n*/\nvar PayPalMessages = function (_a) {\n  var _b = _a.className,\n    className = _b === void 0 ? \"\" : _b,\n    _c = _a.forceReRender,\n    forceReRender = _c === void 0 ? [] : _c,\n    messageProps = __rest$1(_a, [\"className\", \"forceReRender\"]);\n  var _d = usePayPalScriptReducer()[0],\n    isResolved = _d.isResolved,\n    options = _d.options;\n  var messagesContainerRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);\n  var messages = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);\n  var _e = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(null),\n    setErrorState = _e[1];\n  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(function () {\n    // verify the sdk script has successfully loaded\n    if (isResolved === false) {\n      return;\n    }\n    var paypalWindowNamespace = getPayPalWindowNamespace$1(options[SDK_SETTINGS.DATA_NAMESPACE]);\n    // verify dependency on window object\n    if (paypalWindowNamespace === undefined || paypalWindowNamespace.Messages === undefined) {\n      return setErrorState(function () {\n        throw new Error(generateErrorMessage({\n          reactComponentName: PayPalMessages.displayName,\n          sdkComponentKey: \"messages\",\n          sdkRequestedComponents: options.components,\n          sdkDataNamespace: options[SDK_SETTINGS.DATA_NAMESPACE]\n        }));\n      });\n    }\n    messages.current = paypalWindowNamespace.Messages(__assign({}, messageProps));\n    messages.current.render(messagesContainerRef.current).catch(function (err) {\n      // component failed to render, possibly because it was closed or destroyed.\n      if (messagesContainerRef.current === null || messagesContainerRef.current.children.length === 0) {\n        // paypal messages container is no longer in the DOM, we can safely ignore the error\n        return;\n      }\n      // paypal messages container is still in the DOM\n      setErrorState(function () {\n        throw new Error(\"Failed to render <PayPalMessages /> component. \".concat(err));\n      });\n    });\n    // eslint-disable-next-line react-hooks/exhaustive-deps\n  }, __spreadArray([isResolved], forceReRender, true));\n  return react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"div\", {\n    ref: messagesContainerRef,\n    className: className\n  });\n};\nPayPalMessages.displayName = \"PayPalMessages\";\n\n/**\nThis `<PayPalScriptProvider />` component takes care of loading the JS SDK `<script>`.\nIt manages state for script loading so children components like `<PayPalButtons />` know when it's safe to use the `window.paypal` global namespace.\n\nNote: You always should use this component as a wrapper for  `PayPalButtons`, `PayPalMarks`, `PayPalMessages` and `BraintreePayPalButtons` components.\n */\nvar PayPalScriptProvider = function (_a) {\n  var _b;\n  var _c = _a.options,\n    options = _c === void 0 ? {\n      clientId: \"test\"\n    } : _c,\n    children = _a.children,\n    _d = _a.deferLoading,\n    deferLoading = _d === void 0 ? false : _d;\n  var _e = (0,react__WEBPACK_IMPORTED_MODULE_0__.useReducer)(scriptReducer, {\n      options: __assign(__assign({}, options), (_b = {}, _b[SDK_SETTINGS.DATA_JS_SDK_LIBRARY] = SDK_SETTINGS.DATA_LIBRARY_VALUE, _b[SDK_SETTINGS.DATA_SDK_INTEGRATION_SOURCE] = SDK_SETTINGS.DATA_LIBRARY_VALUE, _b[SCRIPT_ID] = \"\".concat(getScriptID(options)), _b)),\n      loadingStatus: deferLoading ? SCRIPT_LOADING_STATE.INITIAL : SCRIPT_LOADING_STATE.PENDING\n    }),\n    state = _e[0],\n    dispatch = _e[1];\n  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(function () {\n    if (deferLoading === false && state.loadingStatus === SCRIPT_LOADING_STATE.INITIAL) {\n      return dispatch({\n        type: DISPATCH_ACTION.LOADING_STATUS,\n        value: SCRIPT_LOADING_STATE.PENDING\n      });\n    }\n    if (state.loadingStatus !== SCRIPT_LOADING_STATE.PENDING) {\n      return;\n    }\n    var isSubscribed = true;\n    loadScript(state.options).then(function () {\n      if (isSubscribed) {\n        dispatch({\n          type: DISPATCH_ACTION.LOADING_STATUS,\n          value: SCRIPT_LOADING_STATE.RESOLVED\n        });\n      }\n    }).catch(function (err) {\n      console.error(\"\".concat(LOAD_SCRIPT_ERROR, \" \").concat(err));\n      if (isSubscribed) {\n        dispatch({\n          type: DISPATCH_ACTION.LOADING_STATUS,\n          value: {\n            state: SCRIPT_LOADING_STATE.REJECTED,\n            message: String(err)\n          }\n        });\n      }\n    });\n    return function () {\n      isSubscribed = false;\n    };\n  }, [state.options, deferLoading, state.loadingStatus]);\n  return react__WEBPACK_IMPORTED_MODULE_0___default().createElement(ScriptContext.Provider, {\n    value: __assign(__assign({}, state), {\n      dispatch: dispatch\n    })\n  }, children);\n};\n\n/**\n * Custom hook to store registered hosted fields children\n * Each `PayPalHostedField` component should be registered on the parent provider\n *\n * @param initialValue the initially registered components\n * @returns at first, an {@link Object} containing the registered hosted fields,\n * and at the second a function handler to register the hosted fields components\n */\nvar useHostedFieldsRegister = function (initialValue) {\n  if (initialValue === void 0) {\n    initialValue = {};\n  }\n  var registeredFields = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(initialValue);\n  var registerHostedField = function (component) {\n    registeredFields.current = __assign(__assign({}, registeredFields.current), component);\n  };\n  return [registeredFields, registerHostedField];\n};\n\n/**\n * Throw an exception if the HostedFields is not found in the paypal namespace\n * Probably cause for this problem is not sending the hosted-fields string\n * as part of the components props in options\n * {@code <PayPalScriptProvider options={{ components: 'hosted-fields'}}>}\n *\n * @param param0 and object containing the components and namespace defined in options\n * @throws {@code Error}\n *\n */\nvar generateMissingHostedFieldsError = function (_a) {\n  var _b = _a.components,\n    components = _b === void 0 ? \"\" : _b,\n    _c = SDK_SETTINGS.DATA_NAMESPACE,\n    _d = _a[_c],\n    dataNamespace = _d === void 0 ? DEFAULT_PAYPAL_NAMESPACE : _d;\n  var expectedComponents = components ? \"\".concat(components, \",hosted-fields\") : \"hosted-fields\";\n  var errorMessage = \"Unable to render <PayPalHostedFieldsProvider /> because window.\".concat(dataNamespace, \".HostedFields is undefined.\");\n  if (!components.includes(\"hosted-fields\")) {\n    errorMessage += \"\\nTo fix the issue, add 'hosted-fields' to the list of components passed to the parent PayPalScriptProvider: <PayPalScriptProvider options={{ components: '\".concat(expectedComponents, \"'}}>\");\n  }\n  return errorMessage;\n};\n/**\n * Validate the expiration date component. Valid combinations are:\n * 1- Only the `expirationDate` field exists.\n * 2- Only the `expirationMonth` and `expirationYear` fields exist. Cannot be used with the `expirationDate` field.\n *\n * @param registerTypes\n * @returns @type {true} when the children are valid\n */\nvar validateExpirationDate = function (registerTypes) {\n  return !registerTypes.includes(PAYPAL_HOSTED_FIELDS_TYPES.EXPIRATION_DATE) && !registerTypes.includes(PAYPAL_HOSTED_FIELDS_TYPES.EXPIRATION_MONTH) && !registerTypes.includes(PAYPAL_HOSTED_FIELDS_TYPES.EXPIRATION_YEAR);\n};\n/**\n * Check if we find the [number, expiration, cvv] in children\n *\n * @param requiredChildren the list with required children [number, expiration, cvv]\n * @param registerTypes    the list of all the children types pass to the parent\n * @throw an @type {Error} when not find the default children\n */\nvar hasDefaultChildren = function (registerTypes) {\n  if (!registerTypes.includes(PAYPAL_HOSTED_FIELDS_TYPES.NUMBER) || !registerTypes.includes(PAYPAL_HOSTED_FIELDS_TYPES.CVV) || validateExpirationDate(registerTypes)) {\n    throw new Error(HOSTED_FIELDS_CHILDREN_ERROR);\n  }\n};\n/**\n * Check if we don't have duplicate children types\n *\n * @param registerTypes the list of all the children types pass to the parent\n * @throw an @type {Error} when duplicate types was found\n */\nvar noDuplicateChildren = function (registerTypes) {\n  if (registerTypes.length !== new Set(registerTypes).size) {\n    throw new Error(HOSTED_FIELDS_DUPLICATE_CHILDREN_ERROR);\n  }\n};\n/**\n * Validate the hosted field children in the PayPalHostedFieldsProvider component.\n * These are the rules:\n * 1- We need to find 3 default children for number, expiration, cvv\n * 2- No duplicate children are allowed\n * 3- No invalid combinations of `expirationDate`, `expirationMonth`, and `expirationYear`\n *\n * @param childrenList     the list of children\n * @param requiredChildren the list with required children [number, expiration, cvv]\n */\nvar validateHostedFieldChildren = function (registeredFields) {\n  hasDefaultChildren(registeredFields);\n  noDuplicateChildren(registeredFields);\n};\n\n/**\nThis `<PayPalHostedFieldsProvider />` provider component wraps the form field elements and accepts props like `createOrder()`.\n\nThis provider component is designed to be used with the `<PayPalHostedField />` component.\n\nWarning: If you don't see anything in the screen probably your client is ineligible.\nTo handle this problem make sure to use the prop `notEligibleError` and pass a component with a custom message.\nTake a look to this link if that is the case: https://developer.paypal.com/docs/checkout/advanced/integrate/\n*/\nvar PayPalHostedFieldsProvider = function (_a) {\n  var styles = _a.styles,\n    createOrder = _a.createOrder,\n    notEligibleError = _a.notEligibleError,\n    children = _a.children,\n    installments = _a.installments;\n  var _b = useScriptProviderContext()[0],\n    options = _b.options,\n    loadingStatus = _b.loadingStatus;\n  var _c = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(true),\n    isEligible = _c[0],\n    setIsEligible = _c[1];\n  var _d = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(),\n    cardFields = _d[0],\n    setCardFields = _d[1];\n  var _e = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(null),\n    setErrorState = _e[1];\n  var hostedFieldsContainerRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);\n  var hostedFields = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)();\n  var _f = useHostedFieldsRegister(),\n    registeredFields = _f[0],\n    registerHostedField = _f[1];\n  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(function () {\n    var _a;\n    validateHostedFieldChildren(Object.keys(registeredFields.current));\n    // Only render the hosted fields when script is loaded and hostedFields is eligible\n    if (!(loadingStatus === SCRIPT_LOADING_STATE.RESOLVED)) {\n      return;\n    }\n    // Get the hosted fields from the [window.paypal.HostedFields] SDK\n    hostedFields.current = getPayPalWindowNamespace$1(options[SDK_SETTINGS.DATA_NAMESPACE]).HostedFields;\n    if (!hostedFields.current) {\n      throw new Error(generateMissingHostedFieldsError((_a = {\n        components: options.components\n      }, _a[SDK_SETTINGS.DATA_NAMESPACE] = options[SDK_SETTINGS.DATA_NAMESPACE], _a)));\n    }\n    if (!hostedFields.current.isEligible()) {\n      return setIsEligible(false);\n    }\n    // Clean all the fields before the rerender\n    if (cardFields) {\n      cardFields.teardown();\n    }\n    hostedFields.current.render({\n      // Call your server to set up the transaction\n      createOrder: createOrder,\n      fields: registeredFields.current,\n      installments: installments,\n      styles: styles\n    }).then(function (cardFieldsInstance) {\n      if (hostedFieldsContainerRef.current) {\n        setCardFields(cardFieldsInstance);\n      }\n    }).catch(function (err) {\n      setErrorState(function () {\n        throw new Error(\"Failed to render <PayPalHostedFieldsProvider /> component. \".concat(err));\n      });\n    });\n  }, [loadingStatus, styles]); // eslint-disable-line react-hooks/exhaustive-deps\n  return react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"div\", {\n    ref: hostedFieldsContainerRef\n  }, isEligible ? react__WEBPACK_IMPORTED_MODULE_0___default().createElement(PayPalHostedFieldsContext.Provider, {\n    value: {\n      cardFields: cardFields,\n      registerHostedField: registerHostedField\n    }\n  }, children) : notEligibleError);\n};\n\n/**\nThis `<PayPalHostedField />` component renders individual fields for [Hosted Fields](https://developer.paypal.com/docs/business/checkout/advanced-card-payments/integrate#3-add-javascript-sdk-and-card-form) integrations.\nIt relies on the `<PayPalHostedFieldsProvider />` parent component for managing state related to loading the JS SDK script\nand execute some validations before the rendering the fields.\n\nTo use the PayPal hosted fields you need to define at least three fields:\n\n- A card number field\n- The CVV code from the client card\n- The expiration date\n\nYou can define the expiration date as a single field similar to the example below,\nor you are able to define it in [two separate fields](https://paypal.github.io/react-paypal-js//?path=/docs/paypal-paypalhostedfields--expiration-date). One for the month and second for year.\n\nNote: Take care when using multiple instances of the PayPal Hosted Fields on the same page.\nThe component will fail to render when any of the selectors return more than one element.\n*/\nvar PayPalHostedField = function (_a) {\n  var hostedFieldType = _a.hostedFieldType,\n    // eslint-disable-line @typescript-eslint/no-unused-vars\n    options = _a.options,\n    // eslint-disable-line @typescript-eslint/no-unused-vars\n    props = __rest$1(_a, [\"hostedFieldType\", \"options\"]);\n  var hostedFieldContext = (0,react__WEBPACK_IMPORTED_MODULE_0__.useContext)(PayPalHostedFieldsContext);\n  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(function () {\n    var _a;\n    if (!(hostedFieldContext === null || hostedFieldContext === void 0 ? void 0 : hostedFieldContext.registerHostedField)) {\n      throw new Error(\"The HostedField cannot be register in the PayPalHostedFieldsProvider parent component\");\n    }\n    // Register in the parent provider\n    hostedFieldContext.registerHostedField((_a = {}, _a[hostedFieldType] = {\n      selector: options.selector,\n      placeholder: options.placeholder,\n      type: options.type,\n      formatInput: options.formatInput,\n      maskInput: options.maskInput,\n      select: options.select,\n      maxlength: options.maxlength,\n      minlength: options.minlength,\n      prefill: options.prefill,\n      rejectUnsupportedCards: options.rejectUnsupportedCards\n    }, _a));\n  }, []); // eslint-disable-line react-hooks/exhaustive-deps\n  return react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"div\", __assign({}, props));\n};\n\n/**\n * Throw an exception if the CardFields is not found in the paypal namespace\n * Probably cause for this problem is not sending the card-fields string\n * as part of the components props in options\n * {@code <PayPalScriptProvider options={{ components: 'card-fields'}}>}\n *\n * @param param0 and object containing the components and namespace defined in options\n * @throws {@code Error}\n *\n */\nvar generateMissingCardFieldsError = function (_a) {\n  var _b = _a.components,\n    components = _b === void 0 ? \"\" : _b,\n    _c = SDK_SETTINGS.DATA_NAMESPACE,\n    _d = _a[_c],\n    dataNamespace = _d === void 0 ? DEFAULT_PAYPAL_NAMESPACE : _d;\n  var expectedComponents = components ? \"\".concat(components, \",card-fields\") : \"card-fields\";\n  var errorMessage = \"Unable to render <PayPalCardFieldsProvider /> because window.\".concat(dataNamespace, \".CardFields is undefined.\");\n  if (!components.includes(\"card-fields\")) {\n    errorMessage += \"\\nTo fix the issue, add 'card-fields' to the list of components passed to the parent PayPalScriptProvider: <PayPalScriptProvider options={{ components: '\".concat(expectedComponents, \"'}}>\");\n  }\n  return errorMessage;\n};\nfunction ignore() {\n  return;\n}\nfunction hasChildren(container) {\n  var _a;\n  return !!((_a = container.current) === null || _a === void 0 ? void 0 : _a.children.length);\n}\nvar PayPalCardFieldsContext = (0,react__WEBPACK_IMPORTED_MODULE_0__.createContext)({\n  cardFieldsForm: null,\n  fields: {},\n  registerField: ignore,\n  unregisterField: ignore // implementation is inside hook and passed through the provider\n});\nvar usePayPalCardFields = function () {\n  return (0,react__WEBPACK_IMPORTED_MODULE_0__.useContext)(PayPalCardFieldsContext);\n};\nvar usePayPalCardFieldsRegistry = function () {\n  var _a = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(null),\n    setError = _a[1];\n  var registeredFields = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)({});\n  var registerField = function () {\n    var props = [];\n    for (var _i = 0; _i < arguments.length; _i++) {\n      props[_i] = arguments[_i];\n    }\n    var fieldName = props[0],\n      options = props[1],\n      cardFields = props[2];\n    if (registeredFields.current[fieldName]) {\n      setError(function () {\n        throw new Error(CARD_FIELDS_DUPLICATE_CHILDREN_ERROR);\n      });\n    }\n    registeredFields.current[fieldName] = cardFields === null || cardFields === void 0 ? void 0 : cardFields[fieldName](options);\n    return registeredFields.current[fieldName];\n  };\n  var unregisterField = function (fieldName) {\n    var field = registeredFields.current[fieldName];\n    if (field) {\n      field.close().catch(ignore);\n      delete registeredFields.current[fieldName];\n    }\n  };\n  return {\n    fields: registeredFields.current,\n    registerField: registerField,\n    unregisterField: unregisterField\n  };\n};\nvar FullWidthContainer = function (_a) {\n  var children = _a.children;\n  return react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"div\", {\n    style: {\n      width: \"100%\"\n    }\n  }, children);\n};\n\n/**\nThe `<PayPalCardFieldsProvider />` is a context provider that is designed to support the rendering and state management of PayPal CardFields in your application.\n\nThe context provider will initialize the `CardFields` instance from the JS SDK and determine eligibility to render the CardField components. Once the `CardFields` are initialized, the context provider will manage the state of the `CardFields` instance as well as the reference to each individual card field.\n\nPassing the `inputEvents` and `style` props to the context provider will apply them to each of the individual field components.\n\nThe state managed by the provider is accessible through our custom hook `usePayPalCardFields`.\n\n*/\nvar PayPalCardFieldsProvider = function (_a) {\n  var children = _a.children,\n    props = __rest$1(_a, [\"children\"]);\n  var proxyInputEvents = useProxyProps(props.inputEvents);\n  var proxyProps = useProxyProps(props);\n  var _b = usePayPalScriptReducer()[0],\n    isResolved = _b.isResolved,\n    options = _b.options;\n  var _c = usePayPalCardFieldsRegistry(),\n    fields = _c.fields,\n    registerField = _c.registerField,\n    unregisterField = _c.unregisterField;\n  var _d = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(null),\n    cardFieldsForm = _d[0],\n    setCardFieldsForm = _d[1];\n  var cardFieldsInstance = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);\n  var _e = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false),\n    isEligible = _e[0],\n    setIsEligible = _e[1];\n  // We set the error inside state so that it can be caught by React's error boundary\n  var _f = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(null),\n    setError = _f[1];\n  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(function () {\n    var _a, _b, _c;\n    if (!isResolved) {\n      return;\n    }\n    if (props.inputEvents) {\n      proxyProps.inputEvents = proxyInputEvents;\n    }\n    try {\n      cardFieldsInstance.current = (_c = (_b = (_a = getPayPalWindowNamespace$1(options[SDK_SETTINGS.DATA_NAMESPACE])).CardFields) === null || _b === void 0 ? void 0 : _b.call(_a, __assign({}, proxyProps))) !== null && _c !== void 0 ? _c : null;\n    } catch (error) {\n      setError(function () {\n        throw new Error(\"Failed to render <PayPalCardFieldsProvider /> component. Failed to initialize:  \".concat(error));\n      });\n      return;\n    }\n    if (!cardFieldsInstance.current) {\n      setError(function () {\n        var _a;\n        throw new Error(generateMissingCardFieldsError((_a = {\n          components: options.components\n        }, _a[SDK_SETTINGS.DATA_NAMESPACE] = options[SDK_SETTINGS.DATA_NAMESPACE], _a)));\n      });\n      return;\n    }\n    setIsEligible(cardFieldsInstance.current.isEligible());\n    setCardFieldsForm(cardFieldsInstance.current);\n    return function () {\n      setCardFieldsForm(null);\n      cardFieldsInstance.current = null;\n    };\n  }, [isResolved]); // eslint-disable-line react-hooks/exhaustive-deps\n  if (!isEligible) {\n    // TODO: What should be returned here?\n    return react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"div\", null);\n  }\n  return react__WEBPACK_IMPORTED_MODULE_0___default().createElement(FullWidthContainer, null, react__WEBPACK_IMPORTED_MODULE_0___default().createElement(PayPalCardFieldsContext.Provider, {\n    value: {\n      cardFieldsForm: cardFieldsForm,\n      fields: fields,\n      registerField: registerField,\n      unregisterField: unregisterField\n    }\n  }, children));\n};\nvar PayPalCardField = function (_a) {\n  var className = _a.className,\n    fieldName = _a.fieldName,\n    options = __rest$1(_a, [\"className\", \"fieldName\"]);\n  var _b = usePayPalCardFields(),\n    cardFieldsForm = _b.cardFieldsForm,\n    registerField = _b.registerField,\n    unregisterField = _b.unregisterField;\n  var containerRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);\n  var proxyInputEvents = useProxyProps(options.inputEvents);\n  // Set errors is state so that they can be caught by React's error boundary\n  var _c = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(null),\n    setError = _c[1];\n  function closeComponent() {\n    unregisterField(fieldName);\n  }\n  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(function () {\n    if (!cardFieldsForm) {\n      setError(function () {\n        throw new Error(CARD_FIELDS_CONTEXT_ERROR);\n      });\n      return closeComponent;\n    }\n    if (!containerRef.current) {\n      return closeComponent;\n    }\n    if (options.inputEvents) {\n      options.inputEvents = proxyInputEvents;\n    }\n    var registeredField = registerField(fieldName, options, cardFieldsForm);\n    registeredField === null || registeredField === void 0 ? void 0 : registeredField.render(containerRef.current).catch(function (err) {\n      if (!hasChildren(containerRef)) {\n        // Component no longer in the DOM, we can safely ignore the error\n        return;\n      }\n      // Component is still in the DOM\n      setError(function () {\n        throw new Error(\"Failed to render <PayPal\".concat(fieldName, \" /> component. \").concat(err));\n      });\n    });\n    return closeComponent;\n  }, []); // eslint-disable-line react-hooks/exhaustive-deps\n  return react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"div\", {\n    ref: containerRef,\n    className: className\n  });\n};\nvar PayPalNameField = function (options) {\n  return react__WEBPACK_IMPORTED_MODULE_0___default().createElement(PayPalCardField, __assign({\n    fieldName: \"NameField\"\n  }, options));\n};\nvar PayPalNumberField = function (options) {\n  return react__WEBPACK_IMPORTED_MODULE_0___default().createElement(PayPalCardField, __assign({\n    fieldName: \"NumberField\"\n  }, options));\n};\nvar PayPalExpiryField = function (options) {\n  return react__WEBPACK_IMPORTED_MODULE_0___default().createElement(PayPalCardField, __assign({\n    fieldName: \"ExpiryField\"\n  }, options));\n};\nvar PayPalCVVField = function (options) {\n  return react__WEBPACK_IMPORTED_MODULE_0___default().createElement(PayPalCardField, __assign({\n    fieldName: \"CVVField\"\n  }, options));\n};\nvar FlexContainer = function (_a) {\n  var children = _a.children;\n  return react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"div\", {\n    style: {\n      display: \"flex\",\n      width: \"100%\"\n    }\n  }, children);\n};\n\n/**\nThis `<PayPalCardFieldsForm />` component renders the 4 individual fields for [Card Fields](https://developer.paypal.com/docs/business/checkout/advanced-card-payments/integrate#3-add-javascript-sdk-and-card-form) integrations.\nThis setup relies on the `<PayPalCardFieldsProvider />` parent component, which manages the state related to loading the JS SDK script and performs certain validations before rendering the fields.\n\n\n\nNote: If you want to have more granular control over the layout of how the fields are rendered, you can alternatively use our Individual Fields.\n*/\nvar PayPalCardFieldsForm = function (_a) {\n  var className = _a.className;\n  return react__WEBPACK_IMPORTED_MODULE_0___default().createElement(\"div\", {\n    className: className\n  }, react__WEBPACK_IMPORTED_MODULE_0___default().createElement(PayPalCardField, {\n    fieldName: \"NameField\"\n  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement(PayPalCardField, {\n    fieldName: \"NumberField\"\n  }), react__WEBPACK_IMPORTED_MODULE_0___default().createElement(FlexContainer, null, react__WEBPACK_IMPORTED_MODULE_0___default().createElement(FullWidthContainer, null, react__WEBPACK_IMPORTED_MODULE_0___default().createElement(PayPalCardField, {\n    fieldName: \"ExpiryField\"\n  })), react__WEBPACK_IMPORTED_MODULE_0___default().createElement(FullWidthContainer, null, react__WEBPACK_IMPORTED_MODULE_0___default().createElement(PayPalCardField, {\n    fieldName: \"CVVField\"\n  }))));\n};\nvar FUNDING$1 = {\n  PAYPAL: \"paypal\",\n  VENMO: \"venmo\",\n  APPLEPAY: \"applepay\",\n  ITAU: \"itau\",\n  CREDIT: \"credit\",\n  PAYLATER: \"paylater\",\n  CARD: \"card\",\n  IDEAL: \"ideal\",\n  SEPA: \"sepa\",\n  BANCONTACT: \"bancontact\",\n  GIROPAY: \"giropay\",\n  SOFORT: \"sofort\",\n  EPS: \"eps\",\n  MYBANK: \"mybank\",\n  P24: \"p24\",\n  PAYU: \"payu\",\n  BLIK: \"blik\",\n  TRUSTLY: \"trustly\",\n  OXXO: \"oxxo\",\n  BOLETO: \"boleto\",\n  BOLETOBANCARIO: \"boletobancario\",\n  WECHATPAY: \"wechatpay\",\n  MERCADOPAGO: \"mercadopago\",\n  MULTIBANCO: \"multibanco\",\n  SATISPAY: \"satispay\",\n  PAIDY: \"paidy\",\n  ZIMPLER: \"zimpler\",\n  MAXIMA: \"maxima\"\n};\n[FUNDING$1.IDEAL, FUNDING$1.BANCONTACT, FUNDING$1.GIROPAY, FUNDING$1.SOFORT, FUNDING$1.EPS, FUNDING$1.MYBANK, FUNDING$1.P24, FUNDING$1.PAYU, FUNDING$1.BLIK, FUNDING$1.TRUSTLY, FUNDING$1.OXXO, FUNDING$1.BOLETO, FUNDING$1.BOLETOBANCARIO, FUNDING$1.WECHATPAY, FUNDING$1.MERCADOPAGO, FUNDING$1.MULTIBANCO, FUNDING$1.SATISPAY, FUNDING$1.PAIDY, FUNDING$1.MAXIMA, FUNDING$1.ZIMPLER];\n\n// We do not re-export `FUNDING` from the `sdk-constants` module\n// directly because it has no type definitions.\n//\n// See https://github.com/paypal/react-paypal-js/issues/125\nvar FUNDING = FUNDING$1;\n\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/@paypal/react-paypal-js/dist/esm/react-paypal-js.js\n");

/***/ })

};
;